# -*- coding: utf-8 -*-
from travel.avia.library.python.avia_data.models.currency import Currency

from travel.avia.library.python.ticket_daemon.memo import memoize, SimpleWarmGroup


@SimpleWarmGroup('modern_currency')
@memoize()
def _currencies():
    return tuple(Currency.objects.all().namedtuples(
        'id', 'code', 'iso_code'
    ))


def make_currency_id_by_code():
    return {code: pk for pk, code, _ in _currencies()}


def make_currency_id_by_iso_code():
    return {iso_code: pk for pk, _, iso_code in _currencies()}
