# -*- coding: utf-8 -*-
from travel.avia.library.python.ticket_daemon.memo import memoize

from travel.avia.ticket_daemon.ticket_daemon.api.models_utils.station import (
    _airport_by_id, get_station_by_iata_or_sirena
)
from travel.avia.ticket_daemon.ticket_daemon.api.models_utils.settlement import (
    _settlement_by_id, _settlement_by_iata, _settlement_by_sirena
)


@memoize()
def _point_tuple_by_key():
    points = {
        's{}'.format(s.id): s for s in _airport_by_id().values()
    }
    points.update({
        'c{}'.format(c.id): c for c in _settlement_by_id().values()
    })
    return points


def get_point_tuple_by_key(key):
    return _point_tuple_by_key().get(key)


def get_point_by_iata_or_sirena(code):
    return (
        _settlement_by_iata().get(code) or
        _settlement_by_sirena().get(code) or
        get_station_by_iata_or_sirena(code)
    )
