# -*- coding: utf-8 -*-
from travel.avia.library.python.common.models.geo import Region
from travel.avia.library.python.common.models.transport import TransportType

from travel.avia.library.python.ticket_daemon.memo import memoize, SimpleWarmGroup


@SimpleWarmGroup('region')
@memoize()
def _region_by_id():
    return {s.id: s for s in (
        Region.objects.filter(station__t_type_id=TransportType.PLANE_ID)
        .distinct().namedtuples(
            'id', 'time_zone',
        )
    )}


def get_region_by_id(region_id):
    return _region_by_id().get(region_id)
