# -*- coding: utf-8 -*-
from travel.avia.library.python.common.models.geo import Settlement
from travel.avia.library.python.ticket_daemon.memo import memoize, SimpleWarmGroup

from travel.avia.ticket_daemon.ticket_daemon.api.models_utils.station import (
    _airport_ids_by_settlement_id
)


@SimpleWarmGroup('settlement')
@memoize()
def _settlement_by_id():
    from .interfaces import SettlementInterface
    return {s.id: s for s in (
        Settlement.objects
        .filter(id__in=_airport_ids_by_settlement_id().keys())
        .namedtuples(
            'id',
            'country_id',
            'iata',
            'sirena_id',
            'time_zone',
            'title',
            computational={
                'point_key': (lambda row: 'c{}'.format(row[0])),
                'settlement_id': (lambda row: row[0]),
            },
            interface=SettlementInterface
        )
    )}


def get_settlement_by_id(settlement_id):
    return _settlement_by_id().get(settlement_id)


@SimpleWarmGroup('settlement_codes')
@memoize()
def _settlement_by_iata():
    return {s.iata: s for s in _settlement_by_id().itervalues()}


@SimpleWarmGroup('settlement_codes')
@memoize()
def _settlement_by_sirena():
    return {s.sirena_id: s for s in _settlement_by_id().itervalues()}
