# -*- coding: utf-8 -*-
from travel.avia.library.python.avia_data.models import TopFlight

from travel.avia.library.python.ticket_daemon.memo import memoize, SimpleWarmGroup

popularity_warm_group = SimpleWarmGroup('popularity')


@popularity_warm_group
@memoize()
def _popularities():
    return dict(
        TopFlight.objects.order_by('redirects').values_list('flights', 'redirects')
    )


@popularity_warm_group
@memoize()
def _flights_redirects_by_weekday_and_national_version():
    redirects = dict()

    for top_flight in TopFlight.objects.values_list('flights', 'day_of_week', 'national_version', 'redirects'):
        redirects[top_flight[:3]] = top_flight[3]

    return redirects


def popularity(flight_numbers):
    """
    :param Iterable[str] flight_numbers:
    """

    return _popularities().get(_join_flight_numbers(flight_numbers), 0)


def popularity_by_weekday_and_national_version(flight_numbers, weekday, national_version):
    """
    :param Iterable[str] flight_numbers:
    :param int weekday:
    :param str national_version:
    """

    joined_flight_numbers = _join_flight_numbers(flight_numbers)
    return _flights_redirects_by_weekday_and_national_version().get((joined_flight_numbers, weekday, national_version), 0)


def _join_flight_numbers(flight_numbers):
    flight_numbers = (f.decode('utf-8') if isinstance(f, str) else f for f in flight_numbers)
    return u';'.join(flight_numbers)
