# -*- coding: utf-8 -*-
from travel.avia.ticket_daemon.ticket_daemon.api.result import Statuses
from travel.avia.ticket_daemon.ticket_daemon.lib.utils import skip_None_values


class PartnerContext(object):
    importer = None
    status = None
    meta = None
    cached_results_count = None
    init_id = None

    @property
    def result(self):
        """query, cache, regionalization_filter, ...?"""
        if self.status == Statuses.SKIP:
            return 'regionalization_filter'
        elif self.status is None:
            return 'query'
        else:
            return 'cache'


class PartnersContext(object):
    def __init__(self, partners, ignore_cache):
        self._ignore_cache = ignore_cache
        self._partners_context = {partner.code: PartnerContext() for partner in partners}
        self.__partners = partners

    def set_statuses(self, partner_code_to_statuses):
        for partner_code, status in skip_None_values(partner_code_to_statuses).iteritems():
            self._partners_context[partner_code].status = status['status']
            self._partners_context[partner_code].cached_results_count = status['all_variants_count']

    def set_partners_meta(self, partners_meta):
        for partner_code, meta in skip_None_values(partners_meta).iteritems():
            self._partners_context[partner_code].init_id = meta.get('qid')

    def set_skip_partners(self, partners):
        """Пропускаем партнеров по правилам регионализации"""
        for partner in partners:
            self._partners_context[partner.code].status = Statuses.SKIP

    def assign_importer(self, importer):
        for partner in importer.partners:
            self._partners_context[partner.code].importer = importer.key

    @property
    def partners(self):
        """
            Партнеры, по которым нужно запустить опрос
            :rtype: typing.List[travel.avia.library.python.common.models.partner.Partner]
        """
        if self._ignore_cache:
            return self.__partners
        else:
            # Пропускаем партнеров, по которым еще не протухли статусы
            return [partner for partner in self.__partners if not self._partners_context[partner.code].status]

    @property
    def context(self):
        return self._partners_context.iteritems()
