import zlib
from abc import abstractmethod, ABCMeta
import ujson as json


class _JsonPackable(object):
    __metaclass__ = ABCMeta

    @abstractmethod
    def to_dict(self):
        pass

    def dumps(self):
        return json.dumps(self.to_dict())

    def pack(self):
        return zlib.compress(self.dumps())


class AbstractResult(_JsonPackable):
    __metaclass__ = ABCMeta

    @abstractmethod
    def cache_key(self, *args, **kwargs):
        pass

    @abstractmethod
    def store(self, *args, **kwargs):
        pass
