# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import itertools
from datetime import timedelta

from travel.avia.ticket_daemon.ticket_daemon.api.flights import Variant  # noqa


class TooFastMoscowErevanFilter(object):
    ZVARTNOTS_ID = 9600369
    EREVAN_STATION_IDS = (ZVARTNOTS_ID,)
    OSTAFYEVO_ID = 9600217
    DOMODEDOVO_ID = 9600216
    VNUKOVO_ID = 9600215
    SHEREMETYEVO_ID = 9600213
    ZHUKOVSKY_ID = 9850865
    MOSCOW_STATION_IDS = (OSTAFYEVO_ID, DOMODEDOVO_ID, VNUKOVO_ID, SHEREMETYEVO_ID, ZHUKOVSKY_ID)
    EREVAN_MOSCOW_MIN_TIME = timedelta(hours=3, minutes=30)
    DIRECTION_MIN_TIMES = {}

    def __init__(self):
        for first_id in self.EREVAN_STATION_IDS:
            for second_id in self.MOSCOW_STATION_IDS:
                self.DIRECTION_MIN_TIMES[(first_id, second_id)] = self.EREVAN_MOSCOW_MIN_TIME
                self.DIRECTION_MIN_TIMES[(second_id, first_id)] = self.EREVAN_MOSCOW_MIN_TIME

    def is_too_fast_variant(self, variant):
        # type: (Variant)->bool
        for segment in itertools.chain(variant.forward.segments, variant.backward.segments or ()):
            min_time = self.DIRECTION_MIN_TIMES.get((segment.station_from.id, segment.station_to.id))
            if min_time and segment.arrival - segment.departure < min_time:
                return True
        return False
