# coding: utf-8
from datetime import datetime

import logging
from itsdangerous import BadSignature, URLSafeSerializer

log = logging.getLogger(__name__)


class YaClid(object):
    _dt_format = '%Y-%m-%dT%H:%M:%S'

    def __init__(self, utc_creation_dt):
        self._utc_creation_dt = utc_creation_dt

    @classmethod
    def create(cls):
        return cls(datetime.utcnow())

    def age(self):
        return datetime.utcnow() - self._utc_creation_dt

    def dumps(self):
        return self._serializer().dumps(self._utc_creation_dt.strftime(self._dt_format))

    @classmethod
    def loads(cls, raw):
        return cls(
            datetime.strptime(cls._serializer().loads(raw), cls._dt_format)
        )

    @classmethod
    def _serializer(cls):
        return URLSafeSerializer(secret_key='wRTSnbCqAQRgTSrLGMwtrlKbRBZcBCGr')

    @classmethod
    def clean(cls, raw):
        try:
            yaclid = cls.loads(raw)
        except BadSignature as exc:
            log.warning('Malformed yaclid: %r (%r)', raw, exc)
            return None

        log.info('YaClid %r -> %s', raw, yaclid.age())

        return yaclid
