# -*- coding: utf-8 -*-
from Queue import Queue

import gevent


class Harvester(object):
    def __init__(self):
        self.entered = False
        self.leaved = False
        self.jobs_queue = Queue()

    def __enter__(self):
        self.entered = True
        self.worker = gevent.spawn(self._run)
        return self

    def __exit__(self, exc_type, exc_value, tb):
        # Ждём пока worker выберет всю очередь задач
        self.jobs_queue.join()

        self.leaved = True

        # Ждём пока worker сам остановится
        self.jobs_queue.put(lambda: None)
        gevent.wait([self.worker])

    def _run(self):
        while not self.leaved:
            job = self.jobs_queue.get()
            # Do work
            job()
            self.jobs_queue.task_done()

    def put_job(self, job):
        if not self.entered:
            raise RuntimeError(u'You need to use Harvester in a with block.')

        if self.leaved:
            raise RuntimeError(u'Its too late to put_job after leave.')

        self.jobs_queue.put(job)
