import logging
from celery.app import Celery

from travel.avia.ticket_daemon.ticket_daemon.settings.sqs import ACCESS_KEY, SECRET_KEY, REVISE_SQS_QUEUE_NAME, ENDPOINT

log = logging.getLogger(__name__)


class Settings:
    BROKER_URL = 'sqs://%s:%s@%s' % (ACCESS_KEY, SECRET_KEY, ENDPOINT)

    BROKER_TRANSPORT_OPTIONS = {
        'is_secure': False,
        'region': 'yandex',
    }
    CELERY_ROUTES = {
        'do_review': {
            'queue': REVISE_SQS_QUEUE_NAME,
        },
    }
    CELERY_QUEUES = {
        REVISE_SQS_QUEUE_NAME: {},
    }


celery_revise_app = Celery('revise')
celery_revise_app.config_from_object(Settings())
