# -*- coding: utf-8 -*-
import logging
from functools import wraps
from traceback import format_exc

from flask import jsonify


log = logging.getLogger(__name__)


def jsend_response(fn):
    @wraps(fn)
    def wrapper(*args, **kwargs):
        try:
            return jsonify({'status': 'ok', 'data': fn(*args, **kwargs)})

        except Exception:
            log.exception('jsend_response wrapper error')

            return jsonify({
                'status': 'fail',
                'description': format_exc(),
            }), 400

    return wrapper
