# -*- coding: utf-8 -*-
from django.conf import settings

from travel.library.python.logbroker.writer import LogbrokerWriter, get_deploy_source_id

__logbroker_processed_qid_writer = None


class NopWriter(LogbrokerWriter):
    def __enter__(self):
        pass

    def __exit__(self, exc_type, exc_val, exc_tb):
        pass

    def write(self, data):
        pass


def get_processed_qid_writer(create_new=False):
    global __logbroker_processed_qid_writer

    producer_id = 'processed_qid_producer'
    get_source_id = get_deploy_source_id

    if __logbroker_processed_qid_writer is None or create_new:
        if __logbroker_processed_qid_writer is not None:
            __logbroker_processed_qid_writer.__exit__(None, None, None)
        if settings.YANDEX_ENVIRONMENT_TYPE == 'development':
            __logbroker_processed_qid_writer = NopWriter(
                settings.LOGBROKER_TOKEN,
                settings.LOGBROKER_PROCESSED_QID_TOPIC,
                source_id=get_source_id(producer_id))
        else:
            __logbroker_processed_qid_writer = LogbrokerWriter(
                settings.LOGBROKER_TOKEN,
                settings.LOGBROKER_PROCESSED_QID_TOPIC,
                source_id=get_source_id(producer_id),
                write_timeout=settings.LOGBROKER_PROCESSED_QID_WRITE_TIMEOUT,
            )
    return __logbroker_processed_qid_writer
