# -*- coding: utf-8 -*-
from collections import namedtuple
from contextlib import contextmanager

from django.conf import settings

from travel.avia.library.python.common.utils.mysql_switcher.base import DatabaseWrapper as CommonDatabaseWrapper
from travel.avia.ticket_daemon.ticket_daemon.lib.decorators import method_decorator


DbContext = namedtuple('DbContext', 'level')


class DatabaseWrapper(CommonDatabaseWrapper):
    _entered = 0

    def real_connect(self):
        if self._entered <= 0 and settings.FAIL_ON_USING_DB_WITHOUT_CONTEXT:
            raise RuntimeError('Need %s context to use db' % self.__class__)
        return super(DatabaseWrapper, self).real_connect()

    @method_decorator(contextmanager)
    def context(self):
        self._entered += 1
        try:
            yield DbContext(self._entered)
        finally:
            self._entered -= 1
