# -*- coding: utf-8 -*-
import logging

from celery import Celery

from travel.avia.ticket_daemon.ticket_daemon.api.query import Query
from travel.avia.ticket_daemon.ticket_daemon.api.result import MinPrice
from travel.avia.ticket_daemon.ticket_daemon.daemon.utils import use_db
from travel.avia.ticket_daemon.ticket_daemon.lib.query_partner_provider import get_related_partners
from travel.avia.ticket_daemon.ticket_daemon.settings.celery import AGGREGATE_MIN_PRICES_TASK

celery_app = Celery('ticket_daemon_sqs')
celery_app.config_from_object('django.conf:settings')

log = logging.getLogger(__name__)


@celery_app.task(name=AGGREGATE_MIN_PRICES_TASK)
def query_aggregate_min_prices_task(qid):
    log.debug(AGGREGATE_MIN_PRICES_TASK)
    try:
        return query_aggregate_min_prices_task_inner(qid)
    except Exception as e:
        log.error(AGGREGATE_MIN_PRICES_TASK + ': %s', e)


@use_db
def query_aggregate_min_prices_task_inner(qid):
    try:
        query = Query.from_qid(qid)
    except Exception:
        log.error('Error restoring query from qid: %r', qid)
        return

    try:
        log.info('aggregate_min_prices query: %s', query.key())
        partners = get_related_partners(
            query,
            mobile=False,  # Не отличаем мобильные для минимальных цен,
            for_init_search=False
        )

        if partners:
            MinPrice.aggregate_query_min_prices(query, partners)
        else:
            log.info('aggregate_min_prices empty related partners list for query: %s', query.key())

    except Exception:
        log.exception('Error in query.aggregate_min_prices()')

    return query.id
