from decorator import decorator


@decorator
def profile_handler(fn, *args, **kwargs):
    import cProfile
    import pstats
    import StringIO

    pr = cProfile.Profile()
    pr.enable()

    result = fn(*args, **kwargs)

    pr.disable()
    s = StringIO.StringIO()
    sortby = 'cumulative'
    ps = pstats.Stats(pr, stream=s).sort_stats(sortby)
    ps.print_stats()
    print s.getvalue()

    return result
