from travel.avia.ticket_daemon.ticket_daemon.lib.baggage import Baggage


class IBaggageCorrectionRule(object):
    def apply(self, flight, baggage):
        raise NotImplementedError


class NumberRangeRule(IBaggageCorrectionRule):
    def __init__(self, left_border, right_border, default_baggage):
        # type: (str, str, Baggage) -> None
        assert left_border <= right_border, 'Left border {} should not be greater than right border {}'.format(left_border, right_border)
        self._left_border = left_border
        self._right_border = right_border
        self._default_baggage = default_baggage

    def apply(self, flight, baggage):
        return self._default_baggage if self._left_border <= flight.number <= self._right_border else baggage


class BaggageCorrector(object):
    def __init__(self):
        # type: () -> None
        self._rules = []

    def correct_baggage(self, flight):
        """
        :type flight: ticket_daemon.api.flights.IATAFlight
        :rtype: ticket_daemon.lib.baggage.Baggage
        """
        baggage = Baggage.from_airline_tariff(flight.company_tariff)
        if flight.company_tariff is not None and not flight.company_tariff.is_default:
            return baggage

        for rule in self._rules:
            baggage = rule.apply(flight, baggage)

        return baggage

    def add_rule(self, rule):
        # type: (NumberRangeRule) -> None

        self._rules.append(rule)

    def __str__(self):
        # type: () -> str
        return 'BaggageCorrector<rules: {}>'.format(
            len(self._rules)
        )


baggage_corrector = BaggageCorrector()
