# -*- coding: utf-8 -*-
import logging

from django.conf import settings

import feature_flag_client
from travel.avia.library.python.flask_helpers import safe_get_request_environ_value

_feature_flags_client = feature_flag_client.Client(
    host=settings.FEATURE_FLAG_HOST, service_code='ticket-daemon', logger=logging.getLogger('feature_flag_client')
)

if settings.YANDEX_ENVIRONMENT_TYPE == 'development':

    class DevelopmentClient(object):
        DEVELOPMENT_FLAGS = []
        if hasattr(settings, 'DEVELOPMENT_FLAGS'):
            DEVELOPMENT_FLAGS = settings.DEVELOPMENT_FLAGS

        def create_context(self):
            return feature_flag_client.Context(set(value.strip() for value in self.DEVELOPMENT_FLAGS))

    _feature_flags_client = DevelopmentClient()

feature_flags_storage = feature_flag_client.Storage(_feature_flags_client)


def multisearch():
    """
    RASPTICKETS-13854 Дополнять выдачу вариантами от не-дохопа
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_S2S_MULTISEARCH')


def save_partners_exception_tracks():
    """
    RASPTICKETS-14651 Сохранять ошибки парсинга ответов партнеров
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('SAVE_PARTNERS_EXCEPTIONS')


def write_in_redis_cache():
    """
    RASPTICKETS-16544
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_WRITE_IN_REDIS')


def read_from_redis_cache():
    """
    RASPTICKETS-16544
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_READ_FROM_REDIS')


def filter_circle_routes():
    """
    RASPTICKETS-16835
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_FILTER_CIRCLE_ROUTES')


def recreate_ydb_session_pool():
    """
    RASPTICKETS-17610 Ошибки сохранения в YDB
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_RECREATE_YDB_SESSION_POOL')


def store_experimental_wizard_results():
    """
    RASPTICKETS-16844
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_STORE_EXPERIMENTAL_WIZARD_RESULTS')


def store_min_tariff_per_fare_code():
    """
    RASPTICKETS-20712
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_STORE_MIN_TARIFF_PER_FARE_CODE')


def enable_new_partner_debugger():
    """
    RASPTICKETS-17261
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_ENABLE_NEW_PARTNER_DEBUGGER')


def log_parse_meta_exceptions():
    """
    RASPTICKETS-18958
    :return:
    """
    return feature_flags_storage.flag_enabled('TD_LOG_PARSE_META_EXCEPTIONS')


def enable_pobeda_new_deeplink():
    """
    RASPTICKETS-17261
    :rtype: bool
    """
    flag = 'TD_ENABLE_POBEDA_NEW_DEEPLINK'
    ab_flags = safe_get_request_environ_value('ab_experiment_flags', default={})

    if ab_flags.get(flag) == '0':
        return False
    return ab_flags.get(flag) == '1' or feature_flags_storage.flag_enabled(flag)


def use_price_prediction():
    """
    RASPTICKETS-20214
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TD_USE_PRICE_PREDICTION')


def aggregate_min_prices_sqs():
    """
    RASPTICKETS-19601 Отправка заданий на аггрегацию минимальных цен в SQS вместо кролика
    :rtype: bool
    """
    return feature_flags_storage.flag_enabled('TICKET_DAEMON_AGGREGATE_MIN_PRICES_SQS')


def heat_partners_cache():
    """
    RASPTICKETS-21342 Прогревать кэш партнёров в фоне
    """

    return feature_flags_storage.flag_enabled('TD_HEAT_PARTNER_CACHE')
