# -*- coding: utf-8 -*-
import urlparse

import requests
from django.utils.http import urlencode
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry


def update_query_string(url, params):
    url_parts = list(urlparse.urlparse(url))
    query = dict(urlparse.parse_qsl(url_parts[4], keep_blank_values=True))
    query.update(params)
    url_parts[4] = urlencode(query)

    return urlparse.urlunparse(url_parts)


def add_param_to_url(name, value, url):
    if not url:
        return url
    return update_query_string(url, {name: value})


def dirty_add_to_query_string(url, params):
    url_parts = list(urlparse.urlparse(url))
    url_parts[4] += ('&' if url_parts[4] and params else '') + urlencode(params)
    return urlparse.urlunparse(url_parts)


def url_complement_missing(url, params):
    url_parts = list(urlparse.urlparse(url))
    url_params = dict(urlparse.parse_qsl(url_parts[4], keep_blank_values=True))
    params = params.copy()
    params.update(url_params)
    url_parts[4] = urlencode(params)

    return urlparse.urlunparse(url_parts)


def with_retry(
    retries=3,
    backoff_factor=0.3,
    status_forcelist=(500, 502, 503, 504),
    method_whitelist=None,
    session=None,
):
    """Добавить в requests.Session функционал retry"""

    session = session or requests.Session()
    retry = Retry(
        total=retries,
        read=retries,
        connect=retries,
        backoff_factor=backoff_factor,
        status_forcelist=status_forcelist,
        method_whitelist=method_whitelist or ['GET', 'POST'],
    )
    adapter = HTTPAdapter(max_retries=retry)
    session.mount('http://', adapter)
    session.mount('https://', adapter)
    return session
