# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import os


class PartnerSecretNotFoundException(Exception):
    def __init__(self, importer_name, namespace):
        self.importer_name = importer_name
        self.namespace = namespace

        self.message = "<PartnerSecretNotFound: importer_name={} namespace={} />".format(
            self.importer_name,
            self.namespace
        )

    def __unicode__(self):
        return "<PartnerSecretNotFound: importer_name={} namespace={} />".format(
            self.importer_name,
            self.namespace
        )


PREFIX = 'AVIA_TICKET_DAEMON_SECRETS_'


class PartnerSecretStorage(object):
    def __init__(self):
        self._storage = {}

    def recache(self):
        storage = {}

        for name in os.environ.keys():
            if name.startswith(PREFIX):
                storage[name[len(PREFIX):]] = os.environ.get(name)

        self._storage = storage

    def get(self, importer_name, namespace):
        key = self._make_key(importer_name, namespace)

        if key not in self._storage:
            raise PartnerSecretNotFoundException(importer_name, namespace)

        return self._storage[key]

    def _make_key(self, importer_name, namespace):
        return '{}_{}'.format(importer_name, namespace).upper()


partner_secret_storage = PartnerSecretStorage()
