# coding=utf-8
from typing import Union

from travel.avia.library.python.common.models.partner import Partner, DohopVendor
from travel.avia.library.python.avia_data.models.amadeus_merchant import AmadeusMerchant


class PartnerStoreTimeProvider(object):
    def get_status_time(self, partner, custom_store_time):
        # type: (Union[Partner, DohopVendor], Union[int, None]) -> int
        """
        Возвращает время на которое нужно сохранить статус в секундах
        НО не меньше, чем на 5 минут (Защита от дурака)
        """
        store_time = self._get_cache_time(partner)
        if custom_store_time:
            store_time = int(custom_store_time / 60)

        return max(store_time, 5) * 60

    def get_result_time(self, partner, custom_store_time):
        # type: (Union[Partner, DohopVendor], Union[int, None]) -> int
        """
        Возвращает время на которое нужно сохранить результат в секундах
        """
        return self.get_status_time(partner, custom_store_time) + 5 * 60

    def _get_cache_time(self, partner):
        if isinstance(partner, Partner):
            return partner.variant_cache_ttl
        if isinstance(partner, DohopVendor):
            return partner.dohop_cache_ttl
        if isinstance(partner, AmadeusMerchant):
            return partner.variant_cache_ttl
        raise Exception('Do not support this type for[{}] partner'.format(type(partner)))


partner_store_time_provider = PartnerStoreTimeProvider()
