# -*- coding: utf-8 -*-
from logging import getLogger
from collections import namedtuple

from django.conf import settings
from feature_flag_client import Client

from travel.avia.library.python.ticket_daemon.memo import memoize, CacheWithKeyTTL


SavingNewSortsSettings = namedtuple(
    'SavingNewSortsSettings',
    ['save_sorted_by_price', 'save_control_with_weekdays', 'save_front_sort', 'save_kateov_sort']
)


__feature_flags_client = Client(
    host=settings.FEATURE_FLAG_HOST,
    service_code='ticket-daemon',
    logger=getLogger('feature_flag_client')
)


@memoize(cache=CacheWithKeyTTL(5 * 60))
def saving_new_sorts_settings():
    # type: () -> SavingNewSortsSettings

    context = __feature_flags_client.create_context()

    return SavingNewSortsSettings(
        context.flag_enabled('SAVE_SORTED_BY_PRICE'),
        context.flag_enabled('SAVE_CONTROL_WITH_WEEKDAYS'),
        context.flag_enabled('SAVE_FRONT_SORT'),
        context.flag_enabled('SAVE_KATEOV_SORT'),
    )
