# -*- encoding: utf-8 -*-
import random
from datetime import datetime, timedelta

from django.conf import settings

from travel.avia.library.python.common.models.geo import StationCode
from travel.avia.library.python.common.models.schedule import Company
from travel.avia.library.python.common.models.transport import TransportType
from travel.avia.ticket_daemon.ticket_daemon.api.flights import IATAFlight, Variant
from travel.avia.ticket_daemon.ticket_daemon.lib.currency import Price
from travel.avia.ticket_daemon.ticket_daemon.lib.decorators import pipe


# todo kill
def synthetic_query_fn(tracker, q, variants_count=None):
    if not variants_count:
        variants_count = int(300 ** random.random())

    companies = [
        c for c in
        Company.objects.filter(hidden=False, t_type_id=TransportType.PLANE_ID)
        if c.iata
    ]
    iatas = list(
        StationCode.objects.filter(
            station__hidden=False,
            system__code='iata',
            code__gte='',
        )
        .values_list('code', flat=True)
    )
    return [
        synth_variant(q, companies, iatas)
        for _ in range(variants_count)
    ]


def synth_variant(q, companies, iatas):
    v = Variant()

    v.tariff = Price(
        random.random() * 10**5,
        settings.AVIA_NATIONAL_CURRENCIES[q.national_version]
    )

    v.forward.segments = synth_flights(companies, iatas, q.point_from.iata, q.point_to.iata, q.date_forward)

    if q.date_backward:
        v.backward.segments = synth_flights(companies, iatas, q.point_to.iata, q.point_from.iata, q.date_backward)

    v.url = 'https://{}'.format(random.random())

    v.klass = q.klass

    v.order_data = {
        'url': v.url
    }

    v.partner_code = random.choice(q.importer.partners).code
    if v.partner_code.startswith('dohop_'):
        v.dohop_vendor_id = int(v.partner_code.split('_')[-1])

    return v


def random_time_in_date(day):
    return datetime(
        day.year, day.month, day.day,
        hour=random.randint(0, 23),
        minute=random.randrange(0, 60, 5)
    )


@pipe(list)
def synth_flights(companies, iatas, iata_from, iata_to, trip_date):
    iata_prev = iata_from
    current_departure_dt = random_time_in_date(trip_date)
    for iata_next in random.sample(iatas, random.randrange(0, 3)) + [iata_to]:
        flight = synth_flight(
            random.choice(companies),
            iata_prev,
            iata_next,
            current_departure_dt
        )
        iata_prev = iata_next
        current_departure_dt = flight.local_arrival + timedelta(minutes=5 * random.randrange(6, 48))
        yield flight


def synth_flight(company, iata_from, iata_to, local_departure):
    f = IATAFlight()

    f.station_from_iata = iata_from
    f.station_to_iata = iata_to

    f.local_departure = local_departure
    f.local_arrival = local_departure + timedelta(
        minutes=60*3 + random.randrange(0, 130, 10)
    )

    f.company_iata = company.iata
    # f.fare_code = 'not_implemented'  # Просто на память
    f.number = '{} {}'.format(f.company_iata, random.randint(10, 999))

    return f
