# -*- coding: utf-8 -*-
from datetime import datetime

from statsd.defaults.django import statsd

from travel.avia.ticket_daemon.ticket_daemon.lib.timer import Timeline, TimelineJson


class StatsdImporterTimeline(Timeline):
    def event(self, event_name, extra=None):
        items = self._items(event_name, extra)
        metric = [event_name]

        if extra and event_name == 'start_import':
            _extra = dict(extra)
            metric.extend([items['service'], _extra['importer']])

        statsd.timing('.'.join(metric), items['elapsed_ms'])
        self._send(items)


class QueryTimeLines(object):
    class Events(object):
        first_partner = 'first_partner'
        last_partner = 'last_partner'
        spawned = 'spawned'
        spawned_importers = 'spawned_importers'
        start_import = 'start_import'

    events = Events()

    @staticmethod
    def add_timelines(query):
        query.timeline_external = TimelineJson(
            'yt.timeline',
            start_time=datetime.utcfromtimestamp(int(query.created)),
        ).with_defaults({
            'qid': query.id, 'service': query.service,
        })

        query.timeline = StatsdImporterTimeline('timeline').with_defaults({
            'qid': query.id, 'service': query.service,
        })

        return query
