# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger


class AirplaneModelLogger(object):
    """
    Сущность для логгирования модели самолета
    """
    def __init__(self, logger):
        self._logger = logger

    def log(self, partner, carrier, flight_number, airplane_model):
        self._logger.log({
            'partner': partner,
            'carrier': carrier,
            'flight_number': flight_number,
            'airplane_model': airplane_model,
        })


airplane_model_logger = AirplaneModelLogger(
    logger=YtLogger(
        name='yt.airplane_model',
        environment=environment
    )
)
