# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger

filter_log = YtLogger(name='yt.json_filter', environment=environment)


def log_filtering(q, q_msg, filtered_count, variants_count, partner_code, filter_name=None, number=0):
    filter_data = {
        'q_msg': q_msg,
        'filter_name': filter_name,
        'filter_number': number,
        'filtered_count': filtered_count,
        'after_count': variants_count,
        'from_id': q.point_from.point_key,
        'to_id': q.point_to.point_key,
        'date_forward': q.date_forward.strftime('%Y-%m-%d'),
        'date_backward': q.date_backward.strftime(
            '%Y-%m-%d') if q.date_backward else '',
        'class': q.klass,
        'adults': q.adults or 0,
        'children': q.children or 0,
        'infants': q.infants or 0,
        'partner': partner_code or '',
    }

    filter_log.log(filter_data)
