# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger


class InitSearchLogger(object):
    """Пишем в момент начала опроса"""
    def __init__(self, logger):
        self._logger = logger

    def log(self, query, partners_context):
        self._logger.log_many(
            self._get_record(query, partner_code, context)
            for partner_code, context in partners_context.context
        )

    def _get_record(self, query, partner_code, context):
        """

        :type query: travel.avia.ticket_daemon.ticket_daemon.api.query.Query
        :type partner_code: str
        :type context: travel.avia.ticket_daemon.ticket_daemon.api.partners_context.PartnerContext
        :return:
        """
        return {
            'qid': query.id,
            'init_id': context.init_id,
            'base_qid': query.meta.get('base_qid'),
            'point_from': query.point_from.point_key,
            'point_to': query.point_to.point_key,
            'date_forward': str(query.date_forward),
            'date_backward': query.date_backward and str(query.date_backward),
            'class': query.klass,
            'adults': query.passengers.get('adults', 0),
            'children': query.passengers.get('children', 0),
            'infants': query.passengers.get('infants', 0),
            'national_version': query.national_version,
            'language': query.lang,
            'service': query.service,  # (wizard_organic, wizard_static, wizard_dynamic)
            'partner_code': partner_code,  # код партнёра или код мерчанта амадеуса или код вендора дохопа
            'importer': context.importer,
            'result': context.result,
            'ignore_cache': bool(query.meta.get('ignore_cache')),
            'experiment_test_ids': query.meta.get('test_id') or '',
            'cached_results_count': context.cached_results_count,  # заполняется только если result=cache, иначе - null
        }


init_search_logger = InitSearchLogger(
    logger=YtLogger(
        name='yt.avia-init-search',
        environment=environment
    )
)
