# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger


class ProcessedQidLogger(object):
    """
    Пишем по одной записи для ответа каждого партнёра с количеством вариантов, которое сохранили в кэш.
    Отдельное поле с признаком "кэш" - взяли из кэша или из живого опроса.
    Для партнёров, которые отвечают пачками записываем окончательное состояние.
    """
    def __init__(self, logger):
        self._logger = logger

    def log(self, qid):
        self._logger.log({'qid': qid})


processed_qid_logger = ProcessedQidLogger(
    logger=YtLogger(
        name='yt.processed-qids',
        environment=environment,
    )
)
