# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger


class SearchResultLogger(object):
    """
    Пишем по одной записи для ответа каждого партнёра с количеством вариантов, которое сохранили в кэш.
    Отдельное поле с признаком "кэш" - взяли из кэша или из живого опроса.
    Для партнёров, которые отвечают пачками записываем окончательное состояние.
    """
    def __init__(self, logger):
        self._logger = logger

    def log(self, query, partner_code, importer, result, test_id, variants_count=None, query_time=.0, errors=None):
        self._logger.log({
            'qid': query.id,
            'base_qid': query.meta.get('base_qid'),
            'point_from': query.point_from.point_key,
            'point_to': query.point_to.point_key,
            'date_forward': str(query.date_forward),
            'date_backward': query.date_backward and str(query.date_backward),
            'class': query.klass,
            'adults': query.passengers.get('adults', 0),
            'children': query.passengers.get('children', 0),
            'infants': query.passengers.get('infants', 0),
            'national_version': query.national_version,
            'language': query.lang,
            'service': query.service,
            'partner_code': partner_code,  # код партнёра или код мерчанта амадеуса или код вендора дохопа
            'importer': importer,
            'result': result,  # got_reply|response_error|...
            'variants_count': variants_count,  # количество вариантов после всех фильтраций, положенные в кэш
            'query_time': query_time,  # от инита до момента складывания в кэш
            'experiment_test_ids': test_id or '',
            'errors': errors,  # могут уточнять тип ошибки при response_error
        })


search_result_logger = SearchResultLogger(
    logger=YtLogger(
        name='yt.avia-search-result',
        environment=environment
    )
)
