# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import logging

from django.utils.encoding import force_unicode

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.abstract_yt_logger import IObjectLogger


class TskvLogger(IObjectLogger):
    """
    Обертка над logging.Logger, позволяющая логгировать записи в tskv формате
    """
    def __init__(self, name, environment, tskv_format):
        self._logger = logging.getLogger(name)
        self._environment = environment
        self._tskv_format = tskv_format
        self._tskv_header = 'tskv\ttskv_format=%s\t' % tskv_format

    def log(self, item):

        """
        Логируем объект в tskv
        :param item: dict
        :returns Void
        """
        self._logger.info(self._format(item))

    def log_many(self, items):
        """
        Логируем несколько запись в tskv

        Если есть возможность сгруппировать несколько записей,
        то лучше воспользоваться этим методом, такая записть в три раза быстрее
        """
        if not items:
            return

        """
        TODO:
        Было: self._logger.info('\n'.join([self._format(item) for item in items]))
        Многопоточная классика:
        Так делать в нельзя. Нужно переопределять open() в логгере и юзать flock
        """
        for item in items:
            self.log(item)

    def _format(self, data):
        data['unixtime'] = self._environment.unixtime()

        return self._tskv_header + '\t'.join('%s=%s' % (
            force_unicode(key), force_unicode(value) or ''
        ) for key, value in data.iteritems())
