# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger


class UnknownCompaniesLogger(object):
    """
    Сущность для логирования компаний, которых нет в наших БД
    """
    def __init__(self, logger):
        self._logger = logger

    def log(self, qid, partner_code, segment):
        """
        :type qid: str
        :type partner_code: str
        :type segment: ticket_daemon.api.flights.Segment
        """
        self._logger.log({
            'qid': qid,
            'partner_code': partner_code,
            'company_iata': segment.company_iata,
            'number': segment.number,
        })


unknown_companies_logger = UnknownCompaniesLogger(
    logger=YtLogger(
        name='yt.unknown_companies',
        environment=environment
    )
)
