# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger


class UnknownStationCodesLogger(object):
    """
    Сущность для логирования IATA/SIRENA-кодов, которых нет в наших БД
    """
    def __init__(self, logger):
        self._logger = logger

    def log(self, qid, partner_code, company_iata, flight_number, station_code):
        # type: (str, str, str, str, str) -> None
        self._logger.log({
            'qid': qid,
            'partner_code': partner_code,
            'company_iata': company_iata,
            'flight_number': flight_number,
            'unknown_code': station_code,
        })


unknown_station_codes_logger = UnknownStationCodesLogger(
    logger=YtLogger(
        name='yt.unknown_station_codes',
        environment=environment
    )
)
