# -*- coding: utf-8 -*-
from travel.avia.library.python.common.utils import environment

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.yt_logger import YtLogger


class WizardSearchResultLogger(object):
    def __init__(self, logger):
        self._logger = logger

    def log(self, query, variants_count, min_price, test_id, is_experimental):
        """

        :type query: travel.avia.ticket_daemon.ticket_daemon.api.query.Query
        :param int variants_count:
        :param float min_price: цена в валюте нац. версии
        :param str test_id: количество вариантов после всех фильтраций, положенные в кэш
        :param bool is_experimental:
        """
        self._logger.log({
            'qid': query.id,
            'base_qid': query.meta.get('base_qid'),
            'point_from': query.point_from.point_key,
            'point_to': query.point_to.point_key,
            'date_forward': str(query.date_forward),
            'date_backward': query.date_backward and str(query.date_backward),
            'class': query.klass,
            'adults': query.passengers.get('adults', 0),
            'children': query.passengers.get('children', 0),
            'infants': query.passengers.get('infants', 0),
            'national_version': query.national_version,
            'language': query.lang,
            'service': query.service,
            'variants_count': variants_count,
            'min_price': min_price,
            'experiment_test_ids': test_id or '',
            'is_experimental': is_experimental,
        })


wizard_search_result_logger = WizardSearchResultLogger(
    logger=YtLogger(
        name='yt.wizard-search-result',
        environment=environment
    )
)
