# -*- coding: utf-8 -*-
import logging

try:
    import ujson as json
except ImportError:
    import json

from travel.avia.ticket_daemon.ticket_daemon.lib.yt_loggers.abstract_yt_logger import IObjectLogger


class YtLogger(IObjectLogger):
    """
    Обертка над logging.Logger, позволяющая логгировать записи в json формате
    """
    def __init__(self, name, environment):
        self._logger = logging.getLogger(name)
        self._environment = environment

    def log(self, item):
        """
        Логирует объект в json
        :type item: dict
        :return: None
        """

        if 'unixtime' not in item:
            item['unixtime'] = self._environment.unixtime()

        self._logger.info(json.dumps(item))

    def log_many(self, items):
        """
        Логирует несколько несколько объектов в json-формате
        :type items: typing.Iterable[dict]
        :return: None
        """
        if not items:
            return

        for item in items:
            self.log(item)
