# -*- coding: utf-8 -*-
import os
import logging

from travel.avia.library.python.ticket_daemon.date import unixtime
from travel.avia.ticket_daemon.ticket_daemon.lib.ydb import wizard_cache_experimental as cache
import travel.avia.ticket_daemon.ticket_daemon.management.commands.delete_expired_wizard_ydb_rows as delete_expired_wizard
from ._loggers import setup_logger

logger = logging.getLogger(__name__)


class GarbageCollector(delete_expired_wizard.GarbageCollector):
    DATABASE = cache.DRIVER_CONFIG.database
    TARGET_TABLE = cache.WIZARD_RESULTS_TABLE_NAME
    TTL_TABLE_COUNT = cache.WIZARD_RESULTS_TTL_TABLES_COUNT

    @staticmethod
    def format_ttl_table_name(ttl_table_idx):
        return cache.format_ttl_table_name(ttl_table_idx)


class Command(delete_expired_wizard.Command):
    def handle(self, *db_names, **options):
        if os.getenv('DONT_DELETE_WIZARD_EXPIRED_ROWS'):
            return
        setup_logger(logger, options.get('verbosity'), options.get('add_stdout_handler'))

        gc = GarbageCollector(logger, 20)
        start_ts = unixtime() - options.get('start_ts_shift')
        logger.info('Start')
        gc.delete_expired_by_ttl_table(start_ts, options.get('jobs'))
        logger.info('End')
