# -*- coding: utf-8 -*-
from uuid import uuid4

from travel.avia.ticket_daemon.ticket_daemon.lib.http import add_param_to_url


class PartnerBookNotFoundException(Exception):
    def __init__(self, partner_code, qid):
        self.partner_code = partner_code
        self.qid = qid


MARKER_COMMON_PART = 'a5e969'
MARKER_SUFFIX = '1'


def book(order_data):
    if 'm_url' in order_data:
        return {
            'url': order_data['url'],
            'm_url': order_data['m_url'],
        }

    return order_data['url']


def generate_marker():
    uuid_parts = str(uuid4()).split('-')
    uuid_parts.insert(1, MARKER_COMMON_PART)
    return '-'.join(uuid_parts) + MARKER_SUFFIX


def add_marker_to_url(marker_field_name, marker_value, url):
    return add_param_to_url(marker_field_name, marker_value, url)
