# -*- coding: utf-8 -*-
import logging

from django.conf import settings

from travel.avia.ticket_daemon.ticket_daemon.partners.nemo import NemoImporter
from travel.avia.ticket_daemon.ticket_daemon.api.query import QueryIsNotValid
from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage

nemo_importer = NemoImporter(
    client_id='363338',
    api_key=partner_secret_storage.get(
        importer_name='aerotur', namespace='API_KEY',
    ),
    search_url='http://avia.meta.net.nemo.travel/Meta/AgencyAPI.svc',
    utm_source=None,
    logger=logging.getLogger(__name__)
)


CURRENCY_MAP = settings.AVIA_NATIONAL_CURRENCIES.copy()
# Replace RUR -> RUB
CURRENCY_MAP['ru'] = 'RUB'


KLASS_MAP = {
    'economy': u'economy',
    'business': u'business',
}


def validate_query(q):
    q.validate_passengers(count=6)
    q.validate_klass(KLASS_MAP)

    if q.national_version not in CURRENCY_MAP:
        raise QueryIsNotValid('Unknown currency for national_version {!r}'
                              .format(q.national_version))
    q.national_currency = CURRENCY_MAP[q.national_version]


@QueryTracker.init_query
def query(tracker, q):
    return nemo_importer.query(
        tracker, q
    )
