# -*- coding: utf-8 -*-
from logging import getLogger

from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.partners.nemo import NemoImporter
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage

NO_DEFAULT_VALIDATION = True


def validate_query(q):
    q.validate_passengers(count=6)


nemo_importer = NemoImporter(
    client_id='agentyandexuser',
    api_key=partner_secret_storage.get(importer_name='agent3', namespace='PASSWORD'),
    search_url='http://avia.agent.pro.backend2.nemo.travel/Meta/AgencyAPI.svc',
    utm_source='yandex.avia',
    logger=getLogger(__name__)
)


@QueryTracker.init_query
def query(tracker, q):
    return nemo_importer.query(tracker, q)
