# -*- coding: utf-8 -*-
from logging import getLogger

from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage
from travel.avia.ticket_daemon.ticket_daemon.partners.sig import SigImporter


sig_importer = SigImporter(
    customer_id='Yandex_A4',
    search_url='https://sigag.tais.ru/SIG',
    api_password=partner_secret_storage.get(
        importer_name='azimuth', namespace='PASSWORD'
    ),
    utm={},
    logger=getLogger(__name__),
)


@QueryTracker.init_query
def query(tracker, q):
    return sig_importer.query(tracker, q)


def validate_query(q):
    sig_importer.validate_query(q)
