# -*- coding: utf-8 -*-
from logging import getLogger

from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage
from travel.avia.ticket_daemon.ticket_daemon.partners.sig import SigImporter


def get_tariff_codes(shop_option, logger):
    tariff_codes_dict = {}
    fares = shop_option.xpath('FareInfo/Fares')
    if len(fares) == 0:
        logger.warning('Couldn\'t extract tariff codes from FareInfo for Azimuth: No FareInfo/Fares')
        return {}

    try:
        for fare in fares[0].xpath('Fare'):
            if fare.xpath('PaxType')[0].attrib['AgeCat'] != 'ADT':
                continue
            for itinerary in fare.xpath('Itinerary'):
                for details in itinerary.xpath('FlightSegmentDetails'):
                    tariff_codes_dict[details.attrib['ReservationRefs']] = details.attrib['FareBasis']
    except Exception as exc:
        logger.warning('Couldn\'t extract tariff codes from FareInfo for Azimuth: Bad FareInfo/Fares: ' + str(exc))
        return {}

    return tariff_codes_dict


sig_importer = SigImporter(
    customer_id='Yandex_A4',
    search_url='https://sigag.tais.ru/SIG',
    api_password=partner_secret_storage.get(
        importer_name='azimuth', namespace='PASSWORD'
    ),
    utm={},
    logger=getLogger(__name__),
    tariff_codes_from_fare_info_extractor=get_tariff_codes,
)


@QueryTracker.init_query
def query(tracker, q):
    return sig_importer.query(tracker, q)


def validate_query(q):
    sig_importer.validate_query(q)
