# -*- coding: utf-8 -*-
from logging import getLogger

from travel.avia.ticket_daemon.ticket_daemon.partners.nemo import NemoImporter
from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage

nemo_importer = NemoImporter(
    client_id='yndxbiletikanon',
    api_key=partner_secret_storage.get(importer_name='biletik5', namespace='PASSWORD'),
    search_url='http://meta.biletik.aero/Meta/AgencyAPI.svc',
    utm_source=None,
    logger=getLogger(__name__)
)


@QueryTracker.init_query
def query(tracker, q):
    return nemo_importer.query(tracker, q)
