# -*- coding: utf-8 -*-
from logging import getLogger

from travel.avia.ticket_daemon.ticket_daemon.partners.nemo import NemoImporter
from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage


KLASS_MAP = {
    'economy': 'economy',
    'business': 'business',
}

nemo_importer = NemoImporter(
    client_id='87323',
    api_key=partner_secret_storage.get(
        importer_name='expressavia4', namespace='PASSWORD'
    ),
    search_url='http://btm.meta.net.nemo.travel/Meta/AgencyAPI.svc',
    utm_source='yandexrasp',
    logger=getLogger(__name__)
)


def validate_query(q):
    q.validate_passengers(9, 8, 3)
    q.validate_klass(KLASS_MAP)


@QueryTracker.init_query
def query(tracker, q):
    return nemo_importer.query(
        tracker, q, unquote_target_url=False,
    )
