# -*- coding: utf-8 -*-
from logging import getLogger

import gevent

from travel.avia.ticket_daemon.ticket_daemon.partners.nemo import NemoImporter
from travel.avia.ticket_daemon.ticket_daemon.partners.sig import SigImporter
from travel.avia.ticket_daemon.ticket_daemon.api.query import QueryIsNotValid
from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage
from travel.avia.ticket_daemon.ticket_daemon.daemon.utils import BadPartnerResponse


nemo_importer = NemoImporter(
    client_id='ruslinemetayandex',
    api_key=partner_secret_storage.get(
        importer_name='rusline3', namespace='PASSWORD'
    ),
    search_url='http://avia.airlines.pro.backend2.nemo.travel/Meta/AgencyAPI.svc',
    utm_source=None,
    logger=getLogger(__name__)
)

sig_importer = SigImporter(
    customer_id='Yandex_7R',
    search_url='https://sigag.tais.ru/SIG',
    api_password=partner_secret_storage.get(
        importer_name='rusline4_sig', namespace='PASSWORD'
    ),
    utm={},
    logger=getLogger(__name__),
)


def validate_query(q):
    if q.date_forward == q.date_backward:
        raise QueryIsNotValid('Arrival and departure on the same day')


@QueryTracker.init_query
def query(tracker, q):
    sig = gevent.spawn(sig_importer.query, tracker, q)
    nemo = gevent.spawn(nemo_importer.query, tracker, q)
    bad_response = None
    exception = None
    gevent.joinall([sig, nemo])
    for result in [sig, nemo]:
        if isinstance(result.value, BadPartnerResponse):
            bad_response = result.value
        elif isinstance(result.exception, BaseException):
            exception = result.exception
        elif isinstance(result.value, list) and len(result.value) > 0:
            return result.value
    if bad_response:
        raise bad_response
    if exception:
        raise exception
    return []
