# -*- coding: utf-8 -*-
import urllib
from logging import getLogger

from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.http import url_complement_missing
from travel.avia.ticket_daemon.ticket_daemon.partners.nemo import NemoImporter
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage


class TezTourNemoImporter(NemoImporter):
    def __init__(self, client_id, api_key, search_url, utm_source, logger, national_version):
        super(TezTourNemoImporter, self).__init__(
            client_id, api_key, search_url, utm_source, logger, u'IAgencyAPI/search'
        )
        self._national_version = national_version

    def _generate_url(self, raw_url, unquote_target_url=True):
        # type: (str, bool) -> str
        return url_complement_missing(
            urllib.unquote(raw_url),
            {
                'utm_source': 'site_' + self._national_version,
                'utm_medium': 'cpc',
                'utm_campaign': 'avia',
                'utm_term': '{keyword}',
            },
        )


@QueryTracker.init_query
def query(tracker, q):
    nemo_importer = TezTourNemoImporter(
        client_id='300112',
        api_key=partner_secret_storage.get(importer_name='tez_tour', namespace='PASSWORD'),
        search_url='http://tez-avia.backend.nemo.travel/Meta/AgencyAPI.svc',
        utm_source=None,
        logger=getLogger(__name__),
        national_version=q.national_version
    )

    return nemo_importer.query(tracker, q)
