# -*- coding: utf-8 -*-
from logging import getLogger

import urlparse

from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage
from travel.avia.ticket_daemon.ticket_daemon.partners.sig import SigImporter


importer_name = 'u6'
customer_id = 'Yandex_U6'
search_url = 'https://sigak.tais.ru/SIG'


UTMS = {
    'utm_source': 'yandex',
    'utm_medium': 'meta',
}


def get_tariff_codes(deeplink, logger):
    tariff_codes_forward = []
    tariff_codes_backward = []
    for key, value in sorted(urlparse.parse_qsl(urlparse.urlparse(deeplink).query)):
        if not key.startswith('FBA_'):
            continue
        if key.startswith('FBA_1_'):
            tariff_codes_forward.append(value)
        elif key.startswith('FBA_2_'):
            tariff_codes_backward.append(value)
    if not tariff_codes_forward:
        logger.warning('Couldn\'t extract tariff codes from deeplink: %s', deeplink)
    return tariff_codes_forward, tariff_codes_backward


sig_importer = SigImporter(
    customer_id=customer_id,
    search_url=search_url,
    api_password=partner_secret_storage.get(
        importer_name=importer_name, namespace='PASSWORD'
    ),
    utm=UTMS,
    logger=getLogger(__name__),
    tariff_codes_from_deeplink_extractor=get_tariff_codes,
)


@QueryTracker.init_query
def query(tracker, q):
    return sig_importer.query(tracker, q)


def validate_query(q):
    sig_importer.validate_query(q)
