# -*- coding: utf-8 -*-
from logging import getLogger

from travel.avia.ticket_daemon.ticket_daemon.lib.tracker import QueryTracker
from travel.avia.ticket_daemon.ticket_daemon.lib.partner_secret_storage import partner_secret_storage
from travel.avia.ticket_daemon.ticket_daemon.partners.sig import SigImporter


def get_tariff_codes(deeplink, logger):
    tariff_codes_raw = deeplink.split('?')[0].split('/')[-1]
    tariff_codes_parts = tariff_codes_raw.split('+')
    if not tariff_codes_parts:
        logger.warning('Couldn\'t extract tariff codes from deeplink: %s', deeplink)
    elif len(tariff_codes_parts) == 1:
        tariff_codes_forward = tariff_codes_parts[0].split('.')
        if not tariff_codes_forward:
            logger.warning('Couldn\'t extract tariff codes from deeplink: %s', deeplink)
        return tariff_codes_forward, []
    tariff_codes_forward = tariff_codes_parts[0].split('.')
    tariff_codes_backward = tariff_codes_parts[1].split('.')
    if not tariff_codes_forward or not tariff_codes_backward:
        logger.warning('Couldn\'t extract tariff codes from deeplink: %s', deeplink)
    return tariff_codes_forward, tariff_codes_backward


sig_importer = SigImporter(
    customer_id='Yandex_UT',
    search_url='https://meta-ya.utair.io/api/booking-meta-search/v2/search/',
    api_password=partner_secret_storage.get(
        importer_name='utair', namespace='PASSWORD'
    ),
    utm={'utm_source': 'yandex', 'utm_medium': 'yandex'},
    logger=getLogger(__name__),
    tariff_codes_from_deeplink_extractor=get_tariff_codes,
)


@QueryTracker.init_query
def query(tracker, q):
    return sig_importer.query(tracker, q)


def validate_query(q):
    sig_importer.validate_query(q)
