# -*- coding: utf-8 -*-
import os
import sys
import logging

import django
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.ticket_daemon.ticket_daemon.settings')
django.setup()

from django.conf import settings

from travel.avia.library.python.avia_data.libs.currency.rates.caching import CurrencyRatesCache
from travel.avia.library.python.common.utils.currency_converter import ConverterCache


LOG_NAME, _ = os.path.splitext(os.path.basename(__file__))
LOG_PATH = settings.LOG_PATH

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s: %(message)s'
        },
    },
    'handlers': {
        LOG_NAME: {
            'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'main', LOG_NAME + '.log'),
            'formatter': 'verbose',
            'level': 'INFO',
        },
    },
    'loggers': {
        LOG_NAME: {
            'handlers': [LOG_NAME],
            'level': 'INFO',
            'propagate': False,
        },
    }
}

logging.config.dictConfig(LOGGING)
log = logging.getLogger(LOG_NAME)


def use_rates_cache(rates_cache_cls, national_versions, only_not_exists):
    for national_version in national_versions:
        try:
            if only_not_exists and rates_cache_cls.load(national_version):
                continue
            rates_cache_cls.build(national_version).save()
        except Exception:
            log.exception(
                'Update currency converter cache: %s',
                rates_cache_cls.__name__
            )
            return

        try:
            log.info(
                'Loaded [%s]: %s',
                national_version, rates_cache_cls.load(national_version).rates
            )

        except Exception:
            log.error(
                'Logging saved error [%s] %s',
                national_version, rates_cache_cls.__name__
            )


def _main():
    from optparse import OptionParser
    optparser = OptionParser(description=__doc__)
    optparser.add_option('-v', '--verbose', action="store_true",
                         help=u"выводить лог на экран")
    optparser.add_option('--only-not-exists', action="store_true", help=u"обновляем только если ключа в кеше ещё нет")
    options, args = optparser.parse_args()

    if options.verbose:
        h = logging.StreamHandler(sys.stdout)
        h.setLevel(logging.DEBUG)
        log.addHandler(h)

    for rates_cache_cls, currencies in [
        (CurrencyRatesCache, settings.AVIA_NATIONAL_CURRENCIES.keys()),
        (ConverterCache, settings.NATIONAL_CURRENCIES.keys())
    ]:
        try:
            use_rates_cache(rates_cache_cls, currencies, options.only_not_exists)
        except Exception as e:
            log.exception(
                'use_rates_cache error: %s %s',
                rates_cache_cls.__name__, e
            )


def main():
    try:
        _main()
    except Exception:
        log.exception('Main error')
