#!/usr/bin/env python
# coding: utf-8
import os
import logging
import subprocess
from StringIO import StringIO


LOG_PATH = '/ephemeral/var/log/yandex-ticket-daemon/main/{}.log'.format(os.path.basename(__file__)[:-3])
logging.basicConfig(format=u'%(levelname)-8s [%(asctime)s] %(message)s',
                    level=logging.DEBUG, filename=LOG_PATH)

IO_TIMEOUT = 1200
CONNECTION_TIMEOUT = 10

TRACKS_PATH = '/ephemeral/var/log/yandex-ticket-daemon/track/'
EMULATOR_HOST = 'avia-partners-emu01h-load.haze.yandex.net'
SHARE = 'avia-partners-emul'
TARGET = 'rsync://{}/{}'.format(EMULATOR_HOST, SHARE)

options = ['-avz', '--remove-source-files', '--timeout={}'.format(IO_TIMEOUT),
           '--contimeout={}'.format(CONNECTION_TIMEOUT)]

rsync_command = ['rsync'] + options + [TRACKS_PATH, TARGET]
remove_empty = ['find', TRACKS_PATH, '-empty', '-delete']


def run_command(command):
    logging.info('Starting %s' % ' '.join(command))
    process = subprocess.Popen(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    output, error = process.communicate()
    stdout = StringIO(output).getvalue()
    stderr = StringIO(error).getvalue()
    if stderr:
        logging.error(stderr)
    if stdout:
        logging.info(stdout)

run_command(rsync_command)
logging.info('rsync Done')

run_command(remove_empty)
logging.info('Removing empty directories Done')
