# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

import multiprocessing
import os

from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider

ALLOW_GEOBASE = False

QUERY_PARTNERS_TIMEOUT = 180
PARTNER_QUERY_TIMEOUT = int(env_variable_provider.get('PARTNER_QUERY_TIMEOUT'))

HTTP_TIMEOUT = 3
QUICK_HTTP_TIMEOUT = 0.1
FAIL_ON_USING_DB_WITHOUT_CONTEXT = True
AGGREGATE_MIN_PRICES = env_variable_provider.get('AGGREGATE_MIN_PRICES', required=False, default='true') == 'true'
AGGREGATE_MIN_PRICES_SYNC = env_variable_provider.get('AGGREGATE_MIN_PRICES_SYNC', required=False) == 'true'
"""Запускать синхронно задачу на агрегацию минимальных цен без celery"""

LOGBROKER_TOKEN = env_variable_provider.get('LOGBROKER_TOKEN')
LOGBROKER_PROCESSED_QID_TOPIC = env_variable_provider.get(
    'LOGBROKER_PROCESSED_QID_TOPIC',
    required=False,
    default='/avia/testing/ticket-daemon/processed-qid',
)
LOGBROKER_PROCESSED_QID_WRITE_TIMEOUT = int(
    env_variable_provider.get('LOGBROKER_PROCESSED_QID_WRITE_TIMEOUT', required=False, default=10)
)
LOGBROKER_PROCESSED_QID_WRITE_TO_FILE = env_variable_provider.get('LOGBROKER_PROCESSED_QID_WRITE_TO_FILE', required=False,
                                                                  default='true') == 'true'
LOGBROKER_PROCESSED_QID_WRITE_TO_LB = env_variable_provider.get('LOGBROKER_PROCESSED_QID_WRITE_TO_LB', required=False,
                                                                default='false') == 'true'

STORE_QUERY_PARTNERS_TRACKS_FACTOR = 0

STRESS_PARTNERS_EMULATOR_URL = None

FEATURE_FLAG_HOST = env_variable_provider.get('FEATURE_FLAG_HOST')

SENTRY_DSN = env_variable_provider.get('SENTRY_DSN')

REGISTER_REDIRECT = env_variable_provider.get('REGISTER_REDIRECT') == 'true'
REVISE_FORCE = env_variable_provider.get('REVISE_FORCE') == 'true'

BOOK_REDIRECT_TIMEOUT = int(env_variable_provider.get('BOOK_REDIRECT_TIMEOUT', required=False, default=9))
BOOKING_SERVICE_URL = env_variable_provider.get('BOOKING_SERVICE_URL')
BOOKING_SERVICE_TIMEOUT = int(env_variable_provider.get('BOOKING_SERVICE_TIMEOUT', required=False, default=6))

FARE_FAMILIES_TIMEOUT = int(env_variable_provider.get('FARE_FAMILIES_TIMEOUT', required=False, default=2))
FARE_FAMILIES_URL = env_variable_provider.get(
    'FARE_FAMILIES_URL',
    required=False,
    default='http://fare-families.testing.avia.yandex.net/api/v1/fare-families/tariff',
)
FARE_FAMILIES_ENABLED = env_variable_provider.get('FARE_FAMILIES_ENABLED', required=False, default=False) == 'true'

PARTNERS_DONT_QUERY_TODAY = (
    'amargo', 'biletexpert', 'biletix', 'idealtour' 'tripsta',
)

PAUSE_PING_RESPONSES_FLAGFILE = '/tmp/ticket_daemon_internal_pause_ping_responses_flag'

ENABLE_TVM = env_variable_provider.get('ENABLE_TVM', required=False) == 'true'
if ENABLE_TVM:
    TVM_TOKEN = os.environ['TVMTOOL_LOCAL_AUTHTOKEN']
    TVM_NAME = env_variable_provider.get('TVM_NAME')
    TVM_DESTINATIONS = map(
        int, env_variable_provider.get('TVM_DESTINATIONS').split(',')
    )

STATSD_HOST = 'localhost'
STATSD_PORT = 8125
STATSD_PREFIX = None
STATSD_MAXUDPSIZE = 512

YT_PROXY = 'hahn.yt.yandex.net'
YT_TOKEN = os.getenv('YT_TOKEN')

YT_LOCK_PREFIX = os.getenv('YT_LOCK_PREFIX')

DEVELOPMENT_FLAGS = os.getenv('DEVELOPMENT_FLAGS', '').split(',')

_metric_queue = None


def get_metric_queue():
    global _metric_queue
    if _metric_queue is None:
        _metric_queue = multiprocessing.Queue()
    return _metric_queue


# TODO: RASPTICKETS-22841: Выпилить флаг генерации маркера из ticket-daemon
USE_BACKEND_MARKER_GENERATION = env_variable_provider.get('USE_BACKEND_MARKER_GENERATION', required=False, default='false') == 'true'
# delete this after removing the flag
BACKEND_MARKER_GENERATION_PARTNER_NAMES = set(['aeroflot', 'flyone', 'redwings', 'smartavia'])
