# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from travel.avia.ticket_daemon.ticket_daemon.settings.environment import env_variable_provider
from travel.avia.library.python.redis.settings import RedisConfigurator
from travel.avia.ticket_daemon.ticket_daemon.settings.application import get_metric_queue
from travel.avia.ticket_daemon.ticket_daemon.settings.environment import PKG_VERSION

CACHE_REDIS = bool(env_variable_provider.get('CACHE_REDIS', required=False) == 'true')
SHARED_CACHE_REDIS = bool(env_variable_provider.get('SHARED_CACHE_REDIS', required=False) == 'true')
MULTI_CACHE = False
if CACHE_REDIS:
    MULTI_CACHE = bool(env_variable_provider.get('MULTI_CACHE', required=False, default=True) == 'true')
if MULTI_CACHE:
    SHARED_CACHE_REDIS = True
REDIS_PING_SLEEP_TIME = int(env_variable_provider.get('REDIS_PING_SLEEP_TIME', required=False, default=1000))
REDIS_MAXIMUM_LAG = int(env_variable_provider.get('MAXIMUM_REDIS_REPLICA_LAG', required=False, default=3000))
MDB_API_TOKEN = env_variable_provider.get('MDB_API_TOKEN', required=CACHE_REDIS)


def mcr_caches(hosts):
    if not hosts:
        raise ValueError('cannot configure mcrouter cache without hosts')

    return {
        'default': {
            'LOCATION': hosts,
            'TIMEOUT': 60,
            'LONG_TIMEOUT': 24 * 60 * 60,
            'OPTIONS': {'server_max_value_length': 128 * 1024 * 1024},
            'BACKEND': 'travel.avia.ticket_daemon.ticket_daemon.api.cache.LoggingMemcachedCache'
        }
    }


MCR_DAEMON_CACHES = mcr_caches(env_variable_provider.get('MCR_HOST', required=False, default='localhost:11211'))


def default_cache():
    if CACHE_REDIS:
        return RedisConfigurator(
            service_name=env_variable_provider.get('REDIS_SENTINEL_SERVICE_NAME'),
            redis_cluster_id=env_variable_provider.get('REDIS_CLUSTER_ID'),
            redis_password=env_variable_provider.get('REDIS_PASSWORD'),
            redis_port=int(env_variable_provider.get('REDIS_PORT', required=False, default=26379)),
            socket_timeout=float(env_variable_provider.get('REDIS_SOCKET_TIMEOUT', required=False, default=0.1)),
            oauth_token=MDB_API_TOKEN,
            monitoring_sensor_prefix='default_cache',
            monitoring_metric_queue=get_metric_queue(),
        ).configure_redis()['default']
    else:
        return MCR_DAEMON_CACHES['default']


def shared_cache():
    if SHARED_CACHE_REDIS:
        return RedisConfigurator(
            service_name=env_variable_provider.get('SHARED_REDIS_SENTINEL_SERVICE_NAME'),
            redis_cluster_id=env_variable_provider.get('SHARED_REDIS_CLUSTER_ID'),
            redis_password=env_variable_provider.get('SHARED_REDIS_PASSWORD'),
            redis_port=int(env_variable_provider.get('SHARED_REDIS_PORT', required=False, default=26379)),
            socket_timeout=float(env_variable_provider.get('SHARED_REDIS_SOCKET_TIMEOUT', required=False, default=0.1)),
            oauth_token=MDB_API_TOKEN,
            monitoring_sensor_prefix='shared_cache',
            monitoring_metric_queue=get_metric_queue(),
        ).configure_redis_master_only()['default']
    else:
        return MCR_DAEMON_CACHES['default']


CACHES = {
    'default': default_cache(),
    'shared_cache': shared_cache(),
    'replica_set': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
        'timeout': 60
    }
}

if MULTI_CACHE:
    CACHES['shared_cache'] = shared_cache()
    CACHES['memcached'] = MCR_DAEMON_CACHES['default']

CACHE_PATH = '/var/cache/yandex-ticket-daemon'

CACHEROOT = env_variable_provider.get('CACHEROOT', required=False, default='/{}/'.format(PKG_VERSION))
TICKET_DAEMON_CACHEROOT = (
    env_variable_provider.get('TICKET_DAEMON_CACHEROOT', required=False)
    or '/yandex/ticket-daemon/'
)


def with_suffix(suffix, prefixes):
    return [prefix + suffix for prefix in prefixes]


PRECACHE = with_suffix('.objects.precache', [
    'travel.avia.library.python.common.models.geo:StationType',
    'travel.avia.library.python.common.models.geo:StationMajority',
    'travel.avia.library.python.common.models.geo:Country',
    'travel.avia.library.python.common.models.geo:CodeSystem',
    'travel.avia.library.python.common.models.transport:TransportType',
])
